//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Collections;

namespace FrameworkLibraries
{
	public class EnvironmentMain 
	{
		static void Main(string [] args)
		{
			Console.WriteLine("Wiersz polece: {0}", Environment.CommandLine);
			Console.WriteLine("Katalog: {0}", Environment.CurrentDirectory);
			Console.WriteLine("Kod wyjcia: {0}", Environment.ExitCode);
			Console.WriteLine("Nazwa komputera: {0}", Environment.MachineName);
			Console.Write("NewLine: ");
			string nl = Environment.NewLine;
			foreach(byte c in nl)
			{
				Console.Write("0x{0:X} ", c);
			}
			Console.WriteLine();
			Console.WriteLine("Wersja systemu: {0}", Environment.OSVersion);
			Console.WriteLine("lad stosu: {0}", Environment.StackTrace);
			Console.WriteLine("Katalog systemowy: {0}", Environment.SystemDirectory);
			Console.WriteLine("Liczba taktw: {0}", Environment.TickCount);
			Console.WriteLine("Nazwa domeny uytkownika: {0}", Environment.UserDomainName);
			Console.WriteLine("Interaktywny: {0}", Environment.UserInteractive);
			Console.WriteLine("Nazwa uytkownika: {0}", Environment.UserName);
			Console.WriteLine("Wersja: {0}", Environment.Version);
			Console.WriteLine("Zestaw roboczy: {0}", Environment.WorkingSet);
			Console.WriteLine("Rozwinicie zmiennych rodowiska: {0}", 
				              Environment.ExpandEnvironmentVariables("PATH=%PATH%;INCLUDE=%INCLUDE%"));
			Console.Write("Wiersz polece: ");
			string [] ca = Environment.GetCommandLineArgs();
			foreach(string s in ca)
				Console.Write("{0} ", s);
			Console.WriteLine();
			Console.WriteLine("PATH: {0}", Environment.GetEnvironmentVariable("PATH"));
			IDictionary env = Environment.GetEnvironmentVariables();
			Console.WriteLine("rodowisko: ");
			foreach(DictionaryEntry de in env)
				Console.WriteLine("{0} {1}", de.Key, de.Value);
			Console.WriteLine("Dane aplikacji: {0}", Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData));
			Console.WriteLine("Wsplne dane aplikacji: {0}", Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData));
			Console.WriteLine("Common Program Files: {0}", Environment.GetFolderPath(Environment.SpecialFolder.CommonProgramFiles));
			Console.WriteLine("Cookies: {0}", Environment.GetFolderPath(Environment.SpecialFolder.Cookies));
			Console.WriteLine("Katalog Pulpit: {0}", Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory));
			Console.WriteLine("Ulubione: {0}", Environment.GetFolderPath(Environment.SpecialFolder.Favorites));
			Console.WriteLine("Historia: {0}", Environment.GetFolderPath(Environment.SpecialFolder.History));
			Console.WriteLine("InternetCache: {0}", Environment.GetFolderPath(Environment.SpecialFolder.InternetCache));
			Console.WriteLine("LocalApplicationData: {0}", Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData));
			Console.WriteLine("Osobiste: {0}", Environment.GetFolderPath(Environment.SpecialFolder.Personal));
			Console.WriteLine("ProgramFiles: {0}", Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles));
			Console.WriteLine("Programy: {0}", Environment.GetFolderPath(Environment.SpecialFolder.Programs));
			Console.WriteLine("Ostatnie: {0}", Environment.GetFolderPath(Environment.SpecialFolder.Recent));
			Console.WriteLine("SendTo: {0}", Environment.GetFolderPath(Environment.SpecialFolder.SendTo));
			Console.WriteLine("Menu Start: {0}", Environment.GetFolderPath(Environment.SpecialFolder.StartMenu));
			Console.WriteLine("Startup: {0}", Environment.GetFolderPath(Environment.SpecialFolder.Startup));
			Console.WriteLine("System: {0}", Environment.GetFolderPath(Environment.SpecialFolder.System));
			Console.WriteLine("Szablony: {0}", Environment.GetFolderPath(Environment.SpecialFolder.Templates));
			string [] ld = Environment.GetLogicalDrives();
			foreach(string s in ld)
				Console.Write("{0} ", s);

			Environment.Exit(1);
		}
	}
}